<?php

defined('TEMPLAZA_FRAMEWORK') or exit();

use TemPlazaFramework\Post_TypeFunctions;

if(!class_exists('TemplazaFramework_MetaBox_Portfolio')){
    class TemplazaFramework_MetaBox_Portfolio extends TemplazaFramework_MetaBox{
        // phpcs:disable WordPress.DB.SlowDBQuery.slow_db_query_meta_key
        public function register(){
            // Get all post types without templaza_style
            $metaboxes[] = array(
                'id'            => 'portfolio-options',
                'title'         => esc_html__( 'Portfolio Options', 'templaza-framework' ),
                'post_types'    => array('portfolio'),
                'position'      => 'normal', // normal, advanced, side
                'priority'      => 'default', // high, core, default, low - Priorities of placement
                'store_each'    => true, // Store value of each fields to each post meta
                'sections'      => array(
                    array(
                        'fields' => array(
                            array(
                                'id'        => 'gallery',
                                'type'      => 'gallery',
                                'title'     => esc_html__('Gallery', 'templaza-framework'),
                            ),
                            array(
                                'id'        => 'oembed',
                                'type'      => 'text',
                                'title'     => esc_html__( 'Embed Code', 'templaza-framework' ),
                                'validate'  => 'url',
                            ),
                        ),
                    ),
                ),
            );

            return $metaboxes;
        }

        public function hooks()
        {
            parent::hooks(); // TODO: Change the autogenerated stub

            add_filter("redux/options/{$this->prefix}templaza-options/wordpress_data/translate/post_type_value",
                array($this, 'meta_box_basic_post_type_value'), 10, 2);


            $post_type  = $this -> post_type -> get_post_type();

            if(post_type_exists($post_type) && $this -> post_type ->  get_current_screen_post_type() == $post_type){
                // Add header column to post type list
                if(method_exists($this,'post_type_table_head')) {
                    add_filter('manage_'.$post_type.'_posts_columns', array($this, 'post_type_table_head'));
                }
            }

        }

        /*
         * Add columns for header custom post type in list page
         * @param array $columns
         * */
        public function post_type_table_head($columns){
            $columns = array(
                "cb"                 => "<input type=\"checkbox\" />",
                "title"              => esc_html__("Title", 'templaza-framework'),
//                "home"             => esc_html__("Default",'templaza-framework'),
                "date"               => esc_html__("Date",'templaza-framework')
            );
            return $columns;
        }

        /*
         * Add columns for content custom post type in list page
         * @param string $column_name
         * @param string $post_id
         * */
        public function post_type_table_content($column_name, $post_id ){
            // phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
            if ($column_name == 'home') {
                $home   = get_post_meta($post_id,'home', true);
                $action = $this -> post_type -> get_post_type().'_set_default';
                $nonce  = wp_create_nonce( $action );
                $href   = 'admin.php?action='.$action.'&post='.$post_id.'&_wpnonce='
                    .$nonce.'" class="button button-micro'.($home?' disabled':'');
                if($home){
                    $href   = 'javascript:void();';
                }
                echo '<a href="'.$href.'" class="button button-micro'.($home?' disabled':'').'"'.($home?' disabled':'').'>';
                if($home){
                    echo '<span class="dashicons dashicons-star-filled featured"></span>';
                }else{
                    echo '<span class="dashicons dashicons-star-empty"></span>';
                }
                echo '</a>';
            }
        }

        /*
         * Order by query for custom post type in list page
         * @param array $vars
         * */
        public function post_type_orderby( $vars ) {
            if ( isset( $vars['orderby'] ) && 'home' == $vars['orderby'] ) {
                $vars = array_merge( $vars, array(
                    'meta_key' => 'home',
                    'orderby' => 'meta_value'
                ) );
            }

            return $vars;
        }

        /*
         * Reset value of select field with data is post
         * */
        public function meta_box_basic_post_type_value($value, $post_type){
            if(is_array($value)){
                return array();
            }else{
                return '';
            }
        }

//        public function enqueue(){
//            if ( function_exists( 'wp_enqueue_media' ) ) {
//                wp_enqueue_media();
//            }else {
//                wp_enqueue_script( 'media-upload' );
//                wp_enqueue_script( 'thickbox' );
//                wp_enqueue_style( 'thickbox' );
//            }
//        }

//        /*
//         * Action set home for custom post type in list page
//         * */
//        public function post_type_set_default(){
//            $post_type      = $this -> post_type -> get_post_type();
//            $nonce_name     = isset( $_GET['_wpnonce'] ) ? $_GET['_wpnonce'] : '';
//            $nonce_action   = $post_type.'_set_default';
//
//            // Check if nonce is valid.
//            if ( ! wp_verify_nonce( $nonce_name, $nonce_action ) ) {
//                wp_die('Security issue occure, Please try again!.');
//            }
//            $post_id    = isset($_GET['post'])?$_GET['post']:0;
//            if(!$post_id){
//                wp_die(__('Post or Page creation failed, could not find original post:', 'templaza-framework') . $post_id);
//            }
//
//            $this -> _disable_home_without_post_id($post_id);
//
//            // Set post by post_id to home
//            update_post_meta($post_id, 'home', 1);
//
//            wp_redirect(admin_url('edit.php?post_type='.$post_type));
//            exit;
//        }
    }
}